document.addEventListener('DOMContentLoaded', () => {
    const modal = document.getElementById('waitlist-modal');
    const btns = document.querySelectorAll('.waitlist-btn');
    const closeBtn = document.getElementById('close-waitlist');
    const joinBtn = document.getElementById('join-waitlist-btn');
    const emailInput = document.getElementById('waitlist-email');
    const msg = document.getElementById('waitlist-msg');

    // Open
    btns.forEach(btn => {
        btn.addEventListener('click', () => {
            modal.classList.remove('hidden');
        });
    });

    // Close
    const closeModal = () => {
        modal.classList.add('hidden');
        if (msg) msg.innerText = '';
        if (emailInput) emailInput.value = '';
    };

    if (closeBtn) closeBtn.addEventListener('click', closeModal);
    window.addEventListener('click', (e) => {
        if (e.target === modal) closeModal();
    });

    // Fake Submit
    if (joinBtn) {
        joinBtn.addEventListener('click', () => {
            const email = emailInput.value;
            if (!email || !email.includes('@')) {
                alert('Please enter a valid email.');
                return;
            }
            joinBtn.innerText = 'Submitting...';
            setTimeout(() => {
                joinBtn.innerText = 'Lock In Discount';
                if (msg) msg.innerText = "🎉 You're on the list! Discount secured.";
                setTimeout(closeModal, 2000);
            }, 1000);
        });
    }

    // Logo Click Handler
    const logo = document.getElementById('pricing-logo');
    if (logo) {
        logo.addEventListener('click', () => {
            window.location.href = 'index.html';
        });
    }
});